<?php

namespace ElementPack\Modules\FooeventsCalendar\Widgets;
use ElementPack\Base\Module_Base;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Controls_Manager;


if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Fooevents_Calendar extends Module_Base {

    public function get_name() {
        return 'fooevents-calendar';
    }

    public function get_title() {
        return BDTEP . __('FooEvents Calendar', 'bdthemes-element-pack');
    }

    public function get_icon() {
        return 'bdt-wi-fooevents-calendar';
    }

    public function get_categories() {
        return ['element-pack'];
    }

    public function get_keywords() {
        return ['fooevents', 'events', 'calendar', 'list', 'grid'];
    }

    public function get_style_depends() {
        return ['ep-events-calendar', 'ep-font'];
    }

    public function get_custom_help_url() {
        return 'https://youtu.be/2J4XhOe8J0o';
    }

    public function register_controls() {
        /* -------------------------
            Layout Section
        ------------------------- */
        $this->start_controls_section(
            'fooevents_layout_section',
            [
                'label' => esc_html__('Layout', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_list',
            [
                'label'   => esc_html__('Calendar Layout', 'bdthemes-element-pack'),
                'type'    => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    ''          => esc_html__('Default View', 'bdthemes-element-pack'),
                    'listDay'   => esc_html__('List View Day', 'bdthemes-element-pack'),
                    'listWeek'  => esc_html__('List View Week', 'bdthemes-element-pack'),
                    'listMonth' => esc_html__('List View Month', 'bdthemes-element-pack'),
                    'listYear'  => esc_html__('List View Year', 'bdthemes-element-pack'),
                ],
            ]
        );

        $this->add_control(
            'fooevents_calendar_startday',
            [
                'label'       => esc_html__('Calendar Start Day', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::SELECT,
                'default'     => '0',
                'options'     => [
                    '0' => esc_html__('Sunday', 'bdthemes-element-pack'),
                    '1' => esc_html__('Monday', 'bdthemes-element-pack'),
                    '2' => esc_html__('Tuesday', 'bdthemes-element-pack'),
                    '3' => esc_html__('Wednesday', 'bdthemes-element-pack'),
                    '4' => esc_html__('Thursday', 'bdthemes-element-pack'),
                    '5' => esc_html__('Friday', 'bdthemes-element-pack'),
                    '6' => esc_html__('Saturday', 'bdthemes-element-pack'),
                ],
                'condition'   => [
                    'fooevents_calendar_list!' => ['listYear', 'listMonth', 'listWeek', 'listDay'],
                ],
                'description' => esc_html__('Choose which day the calendar week should start on.', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_default_date',
            [
                'label'          => esc_html__('Default Date', 'bdthemes-element-pack'),
                'type'           => Controls_Manager::DATE_TIME,
                'label_block'    => true,
                'picker_options' => [
                    'enableTime' => false,
                ],
                'description'    => esc_html__('Select the date the calendar should open to (format: YYYY-MM-DD).', 'bdthemes-element-pack'),
                'condition'      => [
                    'fooevents_calendar_list!' => ['listYear', 'listMonth', 'listWeek', 'listDay'],
                ],
            ]
        );

        $this->add_control(
            'fooevents_calendar_include_cat',
            [
                'label'       => esc_html__('Filter by Category', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('featured', 'bdthemes-element-pack'),
                'description' => esc_html__('Enter one or more category slugs separated by commas.', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_num',
            [
                'label'       => esc_html__('Number of Events', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::NUMBER,
                'min'         => 1,
                'max'         => 100,
                'step'        => 1,
                'description' => esc_html__('Set how many events to display.', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_post',
            [
                'label'       => esc_html__('Post IDs', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('Enter multiple post IDs separated by commas (e.g. 123, 456).', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_id',
            [
                'label'       => esc_html__('Calendar ID', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('cal1', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_time_format',
            [
                'label'       => esc_html__('Time Format', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('H.mm', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_calendar_weekends',
            [
                'label'     => esc_html__('Show Weekends', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'label_on'  => esc_html__('Show', 'bdthemes-element-pack'),
                'label_off' => esc_html__('Hide', 'bdthemes-element-pack'),
            ]
        );
        $this->end_controls_section();
        /* -------------------------
            Calendar Header Style Section
        ------------------------- */
        $this->start_controls_section(
            'fooevents_header_style_section',
            [
                'label' => esc_html__('Calendar Header', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'fooevents_header_background',
                'label'    => esc_html__('Background', 'bdthemes-element-pack'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'fooevents_header_border',
                'selector' => '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar',
            ]
        );

        $this->add_responsive_control(
            'fooevents_header_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_header_margin',
            [
                'label'      => esc_html__('Margin', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        /* -------------------------
            Header Text Style Section
        ------------------------- */
        $this->add_control(
            'fooevents_heading_text',
            [
                'label'     => esc_html__('Header Text', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'fooevents_header_text_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'fooevents_header_font_family',
			[
				'label'     => esc_html__( 'Font Family', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar h2' => 'font-family: {{VALUE}}',
				],
			]
		);

        $this->add_control(
            'fooevents_header_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar h2' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'fooevents_header_font_size',
			[
				'label'      => esc_html__('Font Size', 'bdthemes-element-pack'),
				'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
				'selectors'  => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar h2' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
        /* -------------------------
            Today Button Style Section
        ------------------------- */
        $this->add_control(
            'fooevents_buttons_style',
            [
                'label'     => esc_html__('Button\'s Style', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->start_controls_tabs(
            'fooevents_buttons_style_tabs'
        );

        $this->start_controls_tab(
            'fooevents_buttons_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_buttons_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc-state-default' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-toolbar .fc-button-group .fc-button.fc-state-hover' => 'background-position: 0px !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_buttons_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc-state-default' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
			'fooevents_buttons_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fc-state-default' => 'border-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .fc-state-default.fc-state-hover' => 'border-color: {{VALUE}} !important;',
				],
			]
		);

        $this->add_control(
			'fooevents_buttons_font_family',
			[
				'label'     => esc_html__( 'Font Family', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .fc-state-default' => 'font-family: {{VALUE}}',
				],
			]
		);

        $this->add_control(
            'fooevents_buttons_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .fc-state-default' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'fooevents_buttons_font_size',
			[
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .fc-state-default' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'fooevents_buttons_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_buttons_hover_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc-state-default.fc-state-hover' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_buttons_hover_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc-state-default.fc-state-hover' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /* -------------------------
            Table Style Section
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_style_section',
            [
                'label' => esc_html__('Table', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'fooevents_table_color',
            [
                'label'     => esc_html__('Border Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc-unthemed th,
                    {{WRAPPER}} .fc-unthemed td,
                    {{WRAPPER}} .fc-unthemed thead,
                    {{WRAPPER}} .fc-unthemed tbody,
                    {{WRAPPER}} .fc-unthemed .fc-divider,
                    {{WRAPPER}} .fc-unthemed .fc-row,
                    {{WRAPPER}} .fc-unthemed .fc-content,
                    {{WRAPPER}} .fc-unthemed .fc-popover,
                    {{WRAPPER}} .fc-unthemed .fc-list-view,
                    {{WRAPPER}} .fc-unthemed .fc-list-heading td' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_border_width',
            [
                'type'       => Controls_Manager::SLIDER,
                'label'      => esc_html__( 'Border Width', 'bdthemes-element-pack' ),
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 10,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .fc th, {{WRAPPER}} .fc td' =>'border-width: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .fc-list-view' =>'border-width: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .fc-list-table tr:first-child td' =>'border-top-width: 0 !important;',
                    '{{WRAPPER}} .fc-list-table td' =>'border-width: {{SIZE}}{{UNIT}} 0 0 !important;',
                ],
            ]
        );
            
        $this->end_controls_section();
        /* -------------------------
            Table Header Style Section (Default View)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_header_style_section',
            [
                'label'     => esc_html__('Table Header', 'bdthemes-element-pack'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => '',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fc-view-container .fc-basic-view table thead tr td .fc-widget-header' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fc-view-container .fc-basic-view table thead tr td .fc-widget-header' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-basic-view table .fc-head .fc-head-container .fc-row table thead tr th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
			'fooevents_table_header_font_family',
			[
				'label'     => esc_html__( 'Font Family', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-basic-view table .fc-head .fc-head-container .fc-row table thead tr th' => 'font-family: {{VALUE}}',
				],
			]
		);

        $this->add_control(
            'fooevents_table_header_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-basic-view table .fc-head .fc-head-container .fc-row table thead tr th' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
			'fooevents_table_header_font_size',
			[
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-basic-view table .fc-head .fc-head-container .fc-row table thead tr th' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

        $this->end_controls_section();
        /* -------------------------
            Table Body Style Section (Default View)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_body_style_section',
            [
                'label' => esc_html__('Table Body', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => '',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc th, {{WRAPPER}} .fc td, {{WRAPPER}} .fc hr, {{WRAPPER}} .fc thead, {{WRAPPER}} .fc tbody, {{WRAPPER}} .fc-row' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_background_color',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fc th, {{WRAPPER}} .fc td, {{WRAPPER}} .fc hr, {{WRAPPER}} .fc thead, {{WRAPPER}} .fc tbody, {{WRAPPER}} .fc-row' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
			'fooevents_table_body_font_family',
			[
				'label'     => esc_html__( 'Font Family', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .fc th, {{WRAPPER}} .fc td, {{WRAPPER}} .fc hr, {{WRAPPER}} .fc thead, {{WRAPPER}} .fc tbody, {{WRAPPER}} .fc-row' => 'font-family: {{VALUE}} !important;',
				],
			]
		);

        $this->add_control(
            'fooevents_table_body_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .fc th, {{WRAPPER}} .fc td, {{WRAPPER}} .fc hr, {{WRAPPER}} .fc thead, {{WRAPPER}} .fc tbody, {{WRAPPER}} .fc-row' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
			'fooevents_table_body_font_size',
			[
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .fc th, {{WRAPPER}} .fc td, {{WRAPPER}} .fc hr, {{WRAPPER}} .fc thead, {{WRAPPER}} .fc tbody, {{WRAPPER}} .fc-row' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

        $this->add_control(
            'fooevents_table_body_today_background_color',
            [
                'label'     => esc_html__('Today’s Background', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fc-view-container .fc-basic-view table tbody tr td .fc-widget-content.fc-today' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_event_text_color',
            [
                'label'     => esc_html__('Event Text Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-basic-view .fc-body .fc-row .fc-content-skeleton .fc-event-container .fc-content .fc-title' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_event_background_color',
            [
                'label'     => esc_html__('Event Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-basic-view .fc-body .fc-row .fc-content-skeleton .fc-event-container .fc-content' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
        /* -------------------------
            Table Header Style Section (List Day)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_header_list_day',
            [
                'label' => esc_html__('Table Header', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listDay',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_day_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-heading td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_day_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-heading td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_day_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-heading td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'fooevents_table_header_list_day_font_family',
			[
				'label'     => esc_html__( 'Font Family', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-heading td' => 'font-family: {{VALUE}} !important;',
				],
			]
		);

        $this->add_control(
            'fooevents_table_header_list_day_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-heading td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
			'fooevents_table_header_list_day_font_size',
			[
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-heading td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

        $this->end_controls_section();
        /* -------------------------
            Table Body Style Section (List Day)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_body_list_day',
            [
                'label' => esc_html__('Table Body', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listDay',
                ],
            ]
        );

        $this->start_controls_tabs(
            'fooevents_table_body_list_day_tabs'
        );

        $this->start_controls_tab(
            'fooevents_table_body_list_day_normal_tab',
            [
                'label' => esc_html__('Normal', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_day_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_day_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_body_list_day_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'fooevents_table_body_list_day_font_family',
			[
				'label'     => esc_html__( 'Font Family', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item td' => 'font-family: {{VALUE}} !important;',
				],
			]
		);

        $this->add_control(
            'fooevents_table_body_list_day_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
			'fooevents_table_body_list_day_font_size',
			[
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

        $this->add_control(
            'fooevents_table_body_list_day_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'fooevents_table_body_list_day_hover_tab',
            [
                'label' => esc_html__('Hover', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_day_hover_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item:hover td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_day_hover_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item:hover td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_day_hover_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listDay-view .fc-list-table .fc-list-item:hover .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /* -------------------------
            Table Header Style Section (List Week)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_header_list_week',
            [
                'label' => esc_html__('Table Header', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listWeek',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_week_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-heading td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_week_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-heading td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_week_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-heading td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_week_font_family',
            [
                'label'     => esc_html__('Font Family', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::FONT,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-heading td' => 'font-family: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_week_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-heading td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_week_font_size',
            [
                'type'       => Controls_Manager::SLIDER,
                'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-heading td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
        /* -------------------------
            Table Item Style Section (List Week)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_body_list_week',
            [
                'label' => esc_html__('Table Body', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listWeek',
                ],
            ]
        );

        $this->start_controls_tabs(
            'fooevents_table_body_list_week_tabs'
        );

        $this->start_controls_tab(
            'fooevents_table_body_list_week_normal_tab',
            [
                'label' => esc_html__('Normal', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_body_list_week_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_font_family',
            [
                'label'     => esc_html__('Font Family', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::FONT,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item td' => 'font-family: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_body_list_week_font_size',
            [
                'type'       => Controls_Manager::SLIDER,
                'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'fooevents_table_body_list_week_hover_tab',
            [
                'label' => esc_html__('Hover', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_hover_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item:hover td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_hover_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item:hover td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_week_hover_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listWeek-view .fc-list-table .fc-list-item:hover .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /* -------------------------
            Table Header Style Section (List Month)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_header_list_month',
            [
                'label' => esc_html__('Table Header', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listMonth',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_month_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-heading td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_month_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-heading td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_month_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-heading td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_month_font_family',
            [
                'label'     => esc_html__('Font Family', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::FONT,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-heading td' => 'font-family: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_month_font_size',
            [
                'type'       => Controls_Manager::SLIDER,
                'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-heading td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_month_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-heading td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );
        $this->end_controls_section();
        /* -------------------------
            Table Body Style Section (List Month)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_body_list_month',
            [
                'label' => esc_html__('Table Body', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listMonth',
                ],
            ]
        );

        $this->start_controls_tabs(
            'fooevents_table_body_list_month_tabs'
        );

        $this->start_controls_tab(
            'fooevents_table_body_normal_list_month_tab',
            [
                'label' => esc_html__('Normal', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item td' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item .fc-list-item-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_body_list_month_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_font_family',
            [
                'label'     => esc_html__('Font Family', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::FONT,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item td' => 'font-family: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_body_list_month_font_size',
            [
                'label'      => esc_html__('Font Size', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_tab();
        $this->start_controls_tab(
            'fooevents_table_body_list_month_hover_tab',
            [
                'label' => esc_html__('Hover', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_hover_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item:hover td' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item:hover .fc-list-item-title a' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_hover_background', 
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item:hover td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_month_hover_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listMonth-view .fc-list-table .fc-list-item:hover .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /* -------------------------
            Table Header Style Section (List Year)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_header_list_year',
            [
                'label' => esc_html__('Table Header', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listYear',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_year_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-heading td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_year_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-heading td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_year_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-heading td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_year_font_family',
            [
                'label'     => esc_html__('Font Family', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::FONT,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-heading td' => 'font-family: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_header_list_year_font_size',
            [
                'type'       => Controls_Manager::SLIDER,
                'label'      => esc_html__( 'Font Size', 'bdthemes-element-pack' ),
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-heading td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_header_list_year_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-heading td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
        /* -------------------------
            Table Body Style Section (List Year)
        ------------------------- */
        $this->start_controls_section(
            'fooevents_table_body_list_year',
            [
                'label' => esc_html__('Table Body', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'fooevents_calendar_list' => 'listYear',
                ],
            ]
        );

        $this->start_controls_tabs(
            'fooevents_table_body_list_year_tabs'
        );

        $this->start_controls_tab(
            'fooevents_table_body_normal_list_year_tab',
            [
                'label' => esc_html__('Normal', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item td' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item' => 'background: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item td' => 'background: {{VALUE}} !important;',
                ],
            ]
        );
    
        $this->add_responsive_control(
            'fooevents_table_body_list_year_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_font_family',
            [
                'label'     => esc_html__('Font Family', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::FONT,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item td' => 'font-family: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'fooevents_table_body_list_year_font_size',
            [
                'label'      => esc_html__('Font Size', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item td' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_text_transform',
            [
                'label'     => esc_html__('Text Transform', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''           => esc_html__('None', 'bdthemes-element-pack'),
                    'uppercase'  => esc_html__('UPPERCASE', 'bdthemes-element-pack'),
                    'lowercase'  => esc_html__('lowercase', 'bdthemes-element-pack'),
                    'capitalize' => esc_html__('Capitalize', 'bdthemes-element-pack'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item td' => 'text-transform: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'fooevents_table_body_list_year_hover_tab',
            [
                'label' => esc_html__('Hover', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_hover_color',
            [
                'label'     => esc_html__('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item:hover td' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item:hover .fc-list-item-title a' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_hover_background',
            [
                'label'     => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item:hover td' => 'background: {{VALUE}} !important;',
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item:hover .fc-list-item-title a' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'fooevents_table_body_list_year_hover_icon_color',
            [
                'label'     => esc_html__('Dot Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ep-fooevents-calendar .fooevents_calendar .fc-view-container .fc-listYear-view .fc-list-table .fc-list-item:hover .fc-list-item-marker .fc-event-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    private function get_shortcode() {

        $settings = $this->get_settings_for_display();

        $shortcode_attributes = [];

        if (! empty($settings['fooevents_calendar_list'])) {
            $shortcode_attributes[] = sprintf('defaultView="%s"', esc_attr($settings['fooevents_calendar_list']));
        }

        if ('0' !== $settings['fooevents_calendar_startday']) {
            $shortcode_attributes[] = sprintf('firstDay="%s"', esc_attr($settings['fooevents_calendar_startday']));
        }

        if (! empty($settings['fooevents_calendar_default_date'])) {
            $shortcode_attributes[] = sprintf('defaultDate="%s"', esc_attr(date('Y-m-d', strtotime($settings['fooevents_calendar_default_date']))));
        }

        if (! empty($settings['fooevents_calendar_include_cat'])) {
            $shortcode_attributes[] = sprintf('include_cat="%s"', esc_attr($settings['fooevents_calendar_include_cat']));
        }

        if (! empty($settings['fooevents_calendar_num'])) {
            $shortcode_attributes[] = sprintf('num="%s"', esc_attr($settings['fooevents_calendar_num']));
        }

        if (! empty($settings['fooevents_calendar_post'])) {
            $shortcode_attributes[] = sprintf('post="%s"', esc_attr($settings['fooevents_calendar_post']));
        }

        if (! empty($settings['fooevents_calendar_id'])) {
            $shortcode_attributes[] = sprintf('id="%s"', esc_attr($settings['fooevents_calendar_id']));
        }

        if (! empty($settings['fooevents_calendar_time_format'])) {
            $shortcode_attributes[] = sprintf('timeFormat="%s"', esc_attr($settings['fooevents_calendar_time_format']));
        }

        if ('yes' !== $settings['fooevents_calendar_weekends']) {
            $shortcode_attributes[] = 'weekends="false"';
        }

        $attributes_string = ! empty($shortcode_attributes) ? ' ' . implode(' ', $shortcode_attributes) : '';
        
        return sprintf('[fooevents_calendar%s]', $attributes_string);
    }

    public function render() {
        $this->add_render_attribute( 'fooevents_wrapper', 'class', 'ep-fooevents-calendar' );
        ?>
            <div <?php $this->print_render_attribute_string( 'fooevents_wrapper' ); ?>>
                <?php echo do_shortcode($this->get_shortcode()); ?>
            </div>
        <?php
    }

    public function render_plain_content() {
        echo wp_kses_post($this->get_shortcode());
    }
}
