<?php
namespace ElementPack\Includes;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
/**
 * Class WPML_ElementPack_Content_Switcher
 */
class WPML_ElementPack_Content_Switcher extends WPML_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'switcher_items';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return [
			'title',
			'price_card_content',
			'currency_symbol_custom',
			'price',
			'period',
			'button_text',
			'content',
			'price_card_additional_text',
			'link' => ['url']
		];
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {
			case 'title':
				return esc_html__( 'Title', 'bdthemes-element-pack' );

			case 'price_card_content':
				return esc_html__( 'Price Card Content', 'bdthemes-element-pack' );

			case 'currency_symbol_custom':
				return esc_html__( 'Currency Symbol', 'bdthemes-element-pack' );

			case 'price':
				return esc_html__( 'Price', 'bdthemes-element-pack' );

			case 'period':
				return esc_html__( 'Period', 'bdthemes-element-pack' );

			case 'button_text':
				return esc_html__( 'Button Text', 'bdthemes-element-pack' );

			case 'content':
				return esc_html__( 'Content', 'bdthemes-element-pack' );

			case 'price_card_additional_text':
				return esc_html__( 'Additional Text', 'bdthemes-element-pack' );

			case 'link':
				return esc_html__( 'Link', 'bdthemes-element-pack' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'title':
			case 'price_card_content':
			case 'currency_symbol_custom':
			case 'price':
			case 'period':
			case 'button_text':
				return 'LINE';

			case 'content':
			case 'price_card_additional_text':
				return 'VISUAL';

			case 'link':
				return 'LINK';

			default:
				return '';
		}
	}
} 